# Experiment Code for LLA

This repository contains the Python code for the experiments presented in our paper, "LLA: Enhancing Security and Privacy for Generative Models with Logic-Locked Accelerators". This code is provided anonymously.

## Installation

To set up the necessary environment, please use the provided `environment.yml` file with Conda. Follow these steps:

```bash
conda env create -f environment.yml  # Create the Conda environment
conda activate lla_env  # Activate the Conda environment
```

## Running Experiments

Once the environment is activated, you can run all the experiments by executing the main script:

```bash
python experiments.py
```

The experimental trace and results will be automatically logged to a file.

## Customizing Experiments

The `experiments.py` script contains several `TODO` blocks that mark parameters you can adjust to customize the experiments. You can search for the string "TODO" within the `experiments.py` file to find these configurable settings.

**Example of a configurable block:**

Below is an example from the codebase illustrating how you can modify experiment parameters:

```python
def ablation_study_script():
    """
    Script to generate data for the ablation study in the paper.
    """
    ## Which model to test?
    adapter_id = 3                      # TODO: Change this line to run ablation study on another model

    ## Which key sizes to test?
    # key size | log_2
    #  256     | 8
    #  ...
    log2_of_key_sizes = [8, 9, 10, 11, 12, 13]      # TODO: Change this line to run only on a subset of key sizes

    ## How many points to produce for each configuration?
    random_key_count = 100              # TODO: Use a different value to balance statistical accuracy v.s. runtime

    ## What is the subset size for MMLU?
    mmlu_subset_size = 1024             # TODO: Use a different value to balance statistical accuracy v.s. runtime
```

Feel free to explore and modify other parts of the codebase as well to suit your research needs.
